import React, {Component} from 'react';
import Select from "../Select/Select";
import {graphql, compose} from "react-apollo";
import { rolesQuery } from '../../../../api/queries'
import {Card, CardBody, CardText} from "reactstrap";
import BlinkDot from "../../../Loading/BlinkDot";
import ReactTable from "react-table";


class RoleSelect extends Component {

    constructor(props) {
        super(props);

        this.state = {
            permissions: props.permissions,
            permissionsLength: props.permissions.length
        }
    }

    componentDidMount () {
        const {
            data
        } = this.props
        data.refetch()

    }

    render() {
        const {
            data,
            fieldApi
        } = this.props

        if(data.loading) {
            return(<Card>
                <CardBody>
                    <CardText className="text-info">
                        Caricamento in corso{' '}
                        <BlinkDot/>
                        <BlinkDot/>
                        <BlinkDot/>
                    </CardText>
                </CardBody>
            </Card>);
        }

        return (
            <div>
                <div className="row">
                    <div className="col-12">
                        <Select
                            onChange={value => {
                                const role = data.ruolos.filter(item => item.id == value)[0]
                                this.setState({
                                    permissions: role ? role.permessi : [],
                                    permissionsLength: role ? role.permessi.length : 0
                                })
                            }}
                            {...this.props}
                            options={[
                                {label: "Seleziona un\'opzione", value: ''},
                                ...data.ruolos.map((option) => ({
                                    label: option.nomeEsteso,
                                    value: option.id
                                }))
                            ]}
                        />
                    </div>
                </div>

                <div className="row">
                    <div className="col-12">
                        <ReactTable
                            loading={data.loading}
                            data={this.state.permissions}
                            className="-highlight"
                            showPagination={false}
                            pageSize={this.state.permissionsLength}
                            minRows={1}
                            columns={[
                                {
                                    Header: "Permessi",
                                    accessor: "descrizione",
                                    filterable: false,
                                    sortable: false,
                                }
                            ]}

                        />
                    </div>
                </div>
            </div>
        )
    }
}

export default compose(
    graphql(rolesQuery),
)(RoleSelect)

RoleSelect.defaultProps = {};

RoleSelect.propTypes = {};
